<?php
class NewsAdmin
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  function checkNewsEditRights($newsId)
  {
    if(!$this->dbo) return false;
    $userId = $_SESSION['zalogowany_adm']->id;
    $query = "SELECT userId FROM News ";
    $query .= "WHERE id = $newsId AND userId = $userId";
    if($this->dbo->getQuerySingleResult($query)){
      return true;
    }
    else{
      return false;
    }
  }
  function showList($limit, $where = '')
  {
    if(!$this->dbo){
      echo 'Lista newsów nie jest dostępna.';
      return;
    }
    
    //Odczytanie parametru page.
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    $userId = $_SESSION['zalogowany_adm']->id;
    
    //Określenie całkowitej liczby wierszy w tabeli News.
    $query = "SELECT COUNT(*) FROM News WHERE UserId=$userId $where";
    $rowsCount = intval($this->dbo->getQuerySingleResult($query));
    
    //Obliczenie całkowitej liczby stron z wynikami
    if($limit != 0){
      $pages = ceil($rowsCount / $limit);
    
      if($page < 0 || $page >= $pages) $page = 0;
    
      $offset = $page * $limit;
    }
    else{
      $page = 0;
      $pages = 1;
      $offset = 0;
      $limit = $rowsCount;
    }
    
    //Zapytanie pobierające wyniki dla bieżącej strony.
    $query = "SELECT Id, Naglowek, Data ";
    $query .= "FROM News ";
    $query .= "WHERE UserId = $userId $where";
    $query .= "LIMIT $offset, $limit";

    if(!$result = $this->dbo->query($query)){
      return;
    }
    ?>
    <div id="newsListDiv">
    <table>
    <tr>
    <th>Id</th><th>Nagłówek</th><th>Data</th>
    <th>Edycja</th><th>Usuwanie</th>
    </tr>
    <?php
    //Odczytanie wyników zapytania i umieszczenie ich w tabeli HTML.
    while($row = $result->fetch_row()){
      echo '<tr>';
      foreach($row as $val){
        echo "<td>$val</td>";
      }
      echo '<td>';
      echo '<a href="index.php?action=newsAdmin&amp;wtd=showEditForm&amp;id=';
      echo $row[0] . '">Edytuj</a>';
      echo '<td>';
      echo '<a href="index.php?action=newsAdmin&amp;wtd=deleteNews&amp;id=';
      echo $row[0] . '">Usuń</a>';
      echo '</tr>';
    }
    ?>
    </table>
    <div id="paginationDiv">
    <?php echo $this->dbo->getPagination($page, $pages, 
                      'index.php?action=newsAdmin&amp;wtd=ShowList',
                      'Idź do strony: ');
    ?>
    </div>
    </div>
    <?php
  }
  function showEditForm($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Edycja istniejącej wiadomości.
    if($action == 'edit'){
      //Sprawdzenie czy istnieje parametr id.
      if(!isset($_GET['id'])){
        echo 'Brak parametru id.';
        return FORM_DATA_MISSING;
      }
      
      //Sprawdzenie poprawności parametru id.
      if(($id = intval($_GET['id'])) < 1){
        echo 'Nieprawidłowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Sprawdzenie uprawnień.
      if(!$this->checkNewsEditRights($id)){
        echo 'Brak uprawnień.';
        return NOT_ENOUGH_RIGHTS;
      }
      
      //Zapytanie pobierające dane.
      $query = "SELECT * FROM News WHERE id=$id";
      
      if(!$result = $this->dbo->query($query)){
        echo 'Błąd serwera. Niewłaściwe zapytanie MySQL.';
        return SERVER_ERROR;
      }
      if(!$row = $result->fetch_row()){
        echo 'Nieprawidłowy parametr id.';
        return INVALID_NEWS_ID;
      }
      
      //Ustawienie wartości zmiennych używanych w formularzu.
      $id = $row[0];
      $naglowek = $row[2];
      $tresc = $row[3];
      
      $wtd = 'modifyNews';
      $readonly = 'readonly="readonly"';
    }
    //Dodawanie nowej wiadomości.
    else{
      $id = '';
      $naglowek = '';
      $tresc = '';
      $wtd = 'addNews';
      $readonly = '';
    }
    include 'editNewsForm.php';
  }
  function editNews($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane dane.
    if(!isset($_POST['id']) || !isset($_POST['naglowek']) || 
       !isset($_POST['tresc']) ){
      return FORM_DATA_MISSING;
    }
    
    //Zapis danych w zmiennych pomocniczych.
    $id = intval($_POST['id']);
    $naglowek = filter_input(INPUT_POST, 'naglowek', 
      FILTER_SANITIZE_SPECIAL_CHARS);
    $tresc = filter_input(INPUT_POST, 'tresc', 
      FILTER_SANITIZE_SPECIAL_CHARS);
    
    //Sprawdzenie poprawności danych.
    if(($action == 'edit' && $id < 1) ||
       ($action == 'add' && $id < 0)) return INVALID_NEWS_ID;
    
    /*
      Tutaj ewentualne dalsze instrukcje weryfikujące dane.
    */
    
    //Zabezpieczenie znaków specjalnych w parametrach.
    $naglowek = $this->dbo->real_escape_string($naglowek);
    $tresc = $this->dbo->real_escape_string($tresc);
    
    if($action == 'edit'){
      if(!$this->checkNewsEditRights($id)){
        return NOT_ENOUGH_RIGHTS;
      }
    
      $query = "UPDATE News SET naglowek='$naglowek', tresc='$tresc'";
      $query .= "WHERE id=$id ";
    }
    else{
      //Sprawdzenie czy istnieje news o podanym id.
      if($id > 0){
        $query = "SELECT id FROM News WHERE id=$id";
        if($this->dbo->getQuerySingleResult($query) !== false){
          return NEWS_ID_ALREADY_EXISTS;
        }
      }
      
      //Formowanie zapytania.
      $userId = $_SESSION['zalogowany_adm']->id;
      $query = "INSERT INTO News VALUES($id, $userId, '$naglowek', ";
      $query .= "'$tresc', NOW())";
    }
    
    if($this->dbo->query($query)){
      return ACTION_OK;
    }
    else{
      return ACTION_FAILED;
    }
  }
  function showSearchForm()
  {
    //Wyświetlenie formularza wyszukiwania danych.
  }
  function searchNews()
  {
    //Wyszukanie wpisu o zadanych parametrach.
  }
  function deleteNews()
  {
    //Usunięcie wybranego wpisu.
  }
}
?>